<?php

namespace App\Models\Case;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Case extends Model 
{

    protected $table = 'cases';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function notification()
    {
        return $this->hasMany('CaseNotification');
    }

    public function deadline()
    {
        return $this->belongsTo('CaseDeadline');
    }

}